<?php
if ( ! defined( 'ABSPATH' ) )
	exit;

/**
 * Registers your tab in the addon settings page
 *
 * @since 1.0.0
 * @return void
 */
function qsm_addon_gs_connector_register_addon_settings_tabs() {
	global $mlwQuizMasterNext;
	if ( ! is_null( $mlwQuizMasterNext ) && ! is_null( $mlwQuizMasterNext->pluginHelper ) && method_exists( $mlwQuizMasterNext->pluginHelper, 'register_quiz_settings_tabs' ) ) {
		$mlwQuizMasterNext->pluginHelper->register_addon_settings_tab( "Google Sheet Connector", 'qsm_addon_gs_connector_settings_tabs_content' );
	}
}

/**
 * Generates the content for your addon settings tab
 *
 * @since 1.2.0
 * @return void
 */
function qsm_addon_gs_connector_settings_tabs_content() {
	global $mlwQuizMasterNext;
	if ( isset( $_GET['qsmgscode'] ) ) {
		$gsCode = json_decode( base64_decode( $_GET['qsmgscode'] ), true );
		if ( isset( $gsCode['success'] ) && $gsCode['success'] == '1' ) {
			update_option( 'gs_accesscode', $gsCode['accesscode'] );
			$gsCode['tokenData']['expire']	 = $gsCode['tokenData']['created'] + ($gsCode['tokenData']['expires_in'] - 30);
			$tokenJson						 = json_encode( $gsCode['tokenData'] );
			update_option( 'gs_token', $tokenJson );
			$mlwQuizMasterNext->alertManager->newAlert( __( 'You can now configure Google Sheet when editing your quiz using the Google Sheet Connector tab.', 'qsm-google-sheets' ), 'success' );
		} else {
			$mlwQuizMasterNext->alertManager->newAlert( $tokenData['error_description'], 'error' );
		}
	}
	include_once( dirname( __FILE__ ) . "/google-apiclient/quickstart.php" );
	$QSMGS = new QSM_Google_Sheets();
	wp_enqueue_script( 'qsm_google-sheet_js', QSM_GOOGLE_SHEET_URL.'/qsm-google-sheet.js', array( 'jquery' ), '2.1.4', true );
	$gs_conn				 = get_option( 'qsm_addon_gs_connector_settings', '' );
	$gs_defaults			 = array( 'license_key' => '', 'gs-code' => '' );
	$gs_conn				 = wp_parse_args( $gs_conn, $gs_defaults );
	$license				 = isset( $gs_conn['license_key'] ) ? trim( $gs_conn['license_key'] ) : '';
	//If nonce is correct, update api key from passed input
	if ( isset( $_POST["gs_connector_nonce"] ) && wp_verify_nonce( $_POST['gs_connector_nonce'], 'gs_connector' ) ) {
		
		// Save settings
		$saved_license			 = isset( $_POST['license_key'] ) ? sanitize_text_field( wp_unslash( $_POST['license_key'] ) ) : '';
		$gs_conn['license_key']	 = $saved_license;
		// Checks to see if the license key has changed.
		if( class_exists ( 'QSM_Check_License' )) {
			$activation = $mlwQuizMasterNext->check_license->activate( $saved_license, 'Google Sheet Connector' );
		}else{
			$activation = QSM_license::activate( $saved_license, 'Google Sheet Connector' );
		}
		if( !empty($activation) && ( ( __( 'Attempting to activate a bundle\'s parent license', 'qsm-google-sheets' ) == $activation['message'] || __( 'License key revoked', 'qsm-google-sheets' ) == $activation['message'] || __( 'No activations left', 'qsm-google-sheets' ) == $activation['message'] || __( 'License has expired', 'qsm-google-sheets' ) == $activation['message'] ) || 'success' == $activation['status'] ) ) {
			$item_url = 'https://quizandsurveymaster.com/checkout/?edd_license_key='.$license.'&download_id='.GOOGLE_SHEET_ITEM;
			$gs_conn['license_key'] = $saved_license;
			$gs_conn['license_status'] = 'valid';
			$gs_conn['last_validate'] = date("d-m-Y", time());
			$gs_conn['expiry_date'] = isset($activation['expiry_date']) ? $activation['expiry_date'] : "";
			if('success' == $activation['status']) {
				$mlwQuizMasterNext->alertManager->newAlert( __( 'License validated Successfully', 'qsm-google-sheets' ), 'success' );
			}elseif(__( 'License has expired', 'qsm-google-sheets' ) == $activation['message'] ){
				$target_text =  __('License Key Expired. ', 'qsm-google-sheets');
				$target_link = sprintf( $target_text.'<a href="%s" target="_blank">%s</a>', esc_url( $item_url ), __( 'Click here to renew', 'qsm-google-sheets' ) );
				$default_notice = 0;
				$mlwQuizMasterNext->alertManager->newAlert( $target_link, 'error' );
			}else{
				$mlwQuizMasterNext->alertManager->newAlert( $activation['message'], 'error' );
			}
			$mlwQuizMasterNext->alertManager->newAlert(__('Your settings has been saved successfully!', 'qsm-google-sheets'), 'success');
		} else {
			$gs_conn['license_key'] = '';
			$gs_conn['license_status'] = '';
			$gs_conn['last_validate'] = 'invalid';
			$gs_conn['expiry_date'] = '';
			if( "" == $saved_license ) {
				$default_notice = 0;
				$mlwQuizMasterNext->alertManager->newAlert( __('License Key Required ', 'qsm-google-sheets'), 'error' );
			}else{
				$mlwQuizMasterNext->alertManager->newAlert( $activation['message'], 'error' );
			}
		}
		// If same license key was entered.
		if($license != $saved_license) {
			$deactivation = QSM_license::deactivate( $license, 'Google Sheet Connector' );
		}
		update_option( 'qsm_addon_gs_connector_settings', $gs_conn );
	}

	// Load settings
	$gs_accesscode	 = get_option( 'gs_accesscode', '' );
	$gs_conn		 = wp_parse_args( get_option( 'qsm_addon_gs_connector_settings', array() ), array(
		'license_key'	 => '',
		'gs-code'		 => ''
		)
	);
	$date_now = date("d-m-Y");
	$license		 = isset( $gs_conn['license_key'] ) ? trim( $gs_conn['license_key'] ) : '';
	$license_status	 = isset( $gs_conn['license_status'] ) ? $gs_conn['license_status'] : '';
	if( '' != $license && 'valid' == $license_status ) {
		if ( version_compare( $mlwQuizMasterNext->version, '8.1.6', '>' ) && (isset($gs_conn['expiry_date']) && "" != $gs_conn['expiry_date']) && (isset($gs_conn['last_validate']) && "" != $gs_conn['last_validate']) && strtotime($date_now) > strtotime($gs_conn['expiry_date']) && strtotime($date_now) >= strtotime($gs_conn['last_validate']) ) { 
			$item_url = 'https://quizandsurveymaster.com/checkout/?edd_license_key='.$license.'&download_id='.GOOGLE_SHEET_ITEM;
			$target_text =  __('License Key Expired. ', 'qsm-google-sheets');
			$target_link = sprintf( $target_text.'<a style="font-weight: 500;" href="%s" target="_blank">%s</a>', esc_url( $item_url ), __( 'Click here to renew', 'qsm-google-sheets' ) );
			$mlwQuizMasterNext->alertManager->newAlert( $target_link, 'error' );
		}
		$mlwQuizMasterNext->alertManager->showAlerts();
	?>
	<h2><?php echo _e( 'Google Sheet Connector', 'qsm-google-sheets' ); ?></h2>
	<?php if ( empty( $gs_accesscode ) ): ?>
		<p style="color: red;"><?php _e( 'Click "Authorize" to connect Google Drive to allow us to access your spreadsheets.', 'qsm-google-sheets' ); ?></p>
	<?php endif; ?>
	<form action="" method="post">
		<table class="form-table" style="width: 100%;">            
			<tr valign="top">
				<th scope="row"><label for="license_key"><?php _e( 'Addon License Key', 'qsm-google-sheets' ) ?></label></th>
				<td><input type="text" name="license_key" id="license_key" value="<?php echo $gs_conn["license_key"]; ?>"></td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="gs-code"><?php _e( 'Google Access Code', 'qsm-google-sheets' ) ?></label></th>
				<td>
					<input type="hidden" id="gs-code" value="<?php echo $gs_accesscode; ?>">
					<?php $auth_url = $QSMGS->authUrl(); ?>
					<?php if ( ! empty( $gs_accesscode ) ): ?>
						<span style="color:green;font-weight: bold;"><?php _e( 'Connected', 'qsm-google-sheets' ); ?></span>
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<a href="<?php echo $auth_url; ?>"><?php _e( 'Re-Authorize', 'qsm-google-sheets' ); ?></a>
					<?php else: ?>
						<a href="<?php echo $auth_url; ?>"><?php _e( 'Authorize', 'qsm-google-sheets' ); ?></a>
					<?php endif; ?>
				</td>
			</tr>         
		</table>
		<?php wp_nonce_field( 'gs_connector', 'gs_connector_nonce' ); ?>
		<button class="button-primary"><?php _e( 'Save Settings', 'qsm-google-sheets' ); ?></button>
	</form>
	<?php
	}else{
		$params		 = array(
			'please_wait'    => __('Please Wait...', 'qsm-google-sheets'),
			'license_msg'    => __('License Key Required.', 'qsm-google-sheets'),
		);
		wp_localize_script( 'qsm_google-sheet_js', 'qsm_google_sheet_obj', $params );
		$mlwQuizMasterNext->alertManager->showAlerts();?>
		<div class="license_form_parent">
			<div id="license_message" style="display: none;" class="error below-h2"><p><strong class="qsm_google_sheet_validate_message"></strong></div>
			<h4><strong><?php esc_html_e( 'Please validate your licence key. ', 'qsm-google-sheets' ); ?></strong></h4>
			<div class="qsm_google_sheet_validate_parent">
				<form class="rq_validata-license" method="POST">
					<input type="text" placeholder="<?php echo esc_html("Enter your license key"); ?>" class="qsm_google_sheet_validate_input" name="qsm_google_sheet_validate_input" />
					<input type="submit" name="qsm_google_sheet_validate_button" class="qsm_google_sheet_validate_button button button-primary" />
				</form>
			</div>
		</div>
		<?php
	}
}
